<?php
/**
 * Plugin Name:       Ultimate WhatsApp Chat by CastorStudio
 * Plugin URI:        https://www.rtl-theme.com/ultimate-whatsapp-chat-wordpress-plugin/
 * Description:       Ultimate WhatsApp Chat for WordPress is the most complete WhatsApp chat solution that we have ever made. Integrate your business directly into your website with the best and easy way to connect and interact with all your costumers.
 * Version:           1.1.0
 * Author:            gfxi
 * Author URI:        https://www.rtl-theme.com/author/gfxi/
 * Text Domain:       uwac
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'UWAC_VERSION', '1.1.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-uwac-activator.php
 */
function activate_uwac() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-uwac-activator.php';
	Uwac_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-uwac-deactivator.php
 */
function deactivate_uwac() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-uwac-deactivator.php';
	Uwac_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_uwac' );
register_deactivation_hook( __FILE__, 'deactivate_uwac' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-uwac.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_uwac() {

	$plugin = new Uwac();
	$plugin->run();

}
run_uwac();
