<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/**
*
* Theme: 	rounded
*
* @since 1.0.0
* @version 1.0.1
*
*/

class Uwac_button_theme_rounded{
	public function __construct(){
		$this->theme_name   = 'rounded';
		$this->theme_prefix = 'uwac_theme-'.$this->theme_name;
	}
	
	public function get_settings(){
		$theme_id 		= $this->theme_prefix;
		$theme_prefix 	= $theme_id .'__';
		$styles_path 	= CS_UWAC_PLUGIN_URI .'/themes/button/'.$this->theme_name;
		
		$settings 		= array(
			'dependency'	=> array('button_theme_'.$this->theme_name,'==','true'),
			'id'			=> $theme_id,
			'type'			=> 'fieldset',
			'fields'		=> array(
				array(
					'type'			=> 'subheading',
					'content'		=> __('Rounded Button Theme - Settings','uwac'),
				),
				array(
					'id'            => $theme_prefix.'style',
					'type'          => 'select',
					'title'         => __('Style','uwac'),
					'options'		=> array(
						'light'		=> __('Light','uwac'),
						'dark'		=> __('Dark','uwac'),
						'custom'	=> __('Custom','uwac'),
					),
					'default'		=> 'light',
				),
				array(
					'dependency'	=> array($theme_prefix.'style','==','custom'),
					'id'			=> $theme_prefix.'colors',
					'type'			=> 'container',
					'fields'		=> array(
						array(
							'id'        => $theme_prefix.'button_colors',
							'type'      => 'color_group',
							'title'     => __('Button Colors','uwac'),
							'settings'	=> array(
								'width_style'	=> 'inline', // block - inline
							),
							'options'	=> array(
								array(
									'type'	=> 'group',
									'title'	=> __('Normal Colors','uwac'),
									'colors'	=> array(
										'color-normal-bg' 	=> __('Background','uwac'),
										'color-normal-text' => __('Text','uwac'),
									),
								),
								array(
									'type'	=> 'group',
									'title'	=> __('Hover Colors','uwac'),
									'colors'	=> array(
										'color-hover-bg' 	=> __('Background','uwac'),
										'color-hover-text' 	=> __('Text','uwac'),
									),
								),
							),
							'default'   => array(
								'color-normal-bg' 	=> 'rgb(45, 183, 66)',
								'color-normal-text' => '#ffffff',
								'color-hover-bg' 	=> 'rgb(39, 163, 58)',
								'color-hover-text' 	=> '#ffffff',
							),
						),
					),
				),
			),
		);
		return $settings;
	}
	
	public function parse_settings($settings){
		$option = function($option) use ($settings){
			$theme_prefix = $this->theme_prefix.'__';
			return $settings[$theme_prefix.$option];
		};
		$_prefix = $this->theme_prefix.'__';
		
		
		// Parse Settings
		// ==========================================================================
		// $_c = new Colors();
		
		
		// Theme
		$style = $option('style');
		if ($style == 'light' || $style == 'dark'){
			if ($style == 'light'){
				$scheme = array(
					'color-normal-bg' 		=> '#2db742',
					'color-normal-text' 	=> '#ffffff',
					'color-hover-bg' 		=> '#2db742',
					'color-hover-text' 		=> '#ffffff',
				);
			} else if ($style == 'dark'){
				$scheme = array(
					'color-normal-bg' 		=> '#2db742',
					'color-normal-text' 	=> '#ffffff',
					'color-hover-bg' 		=> '#2db742',
					'color-hover-text' 		=> '#ffffff',
				);
			}
			// Button
			$normal_bg 			= $scheme['color-normal-bg'];
			$normal_text 		= $scheme['color-normal-text'];
			$hover_bg 			= $scheme['color-hover-bg'];
			$hover_text 		= $scheme['color-hover-text'];
		} else if ($style == 'custom'){
			$c = $option('colors');
			$b = $c[$_prefix.'button_colors'];

			// Button
			$normal_bg 		= $b['color-normal-bg'];
			$normal_text 	= $b['color-normal-text'];
			$hover_bg 		= $b['color-hover-bg'];
			$hover_text 	= $b['color-hover-text'];
		}

		
		// Output Theme CSS Vars
		// ==========================================================================
		$output = "
			%s_normal-bg:					$normal_bg;
			%s_normal-text: 				$normal_text;
			%s_hover-bg:					$hover_bg;
			%s_hover-text: 					$hover_text;
		";
		$prefix = CS_UWAC_CSS_THEME_SLUG;
		$output = str_replace('%s',$prefix,$output);
		return $output;
	}
}