(function( $ ) {
	'use strict';
	
	$.fn.CSUWAC = function() {
		return this.each( function() {
			var _CSUWAC = {};

			var $popup = $(this);
			
			_CSUWAC.init = function(popup){
				var ctaAnimationTimeout;
				var ctaAutoOpenTimeout;
				
				this.popup(popup);
				this.GDPRInit(popup);
				this.autoOpen(popup);
				this.ctaAnimation(popup);
			};
			_CSUWAC.popup = function(popup){
				var self = this;
				
				// Show & Hide Popups
				$(".cs-uwac__popup-btn",popup).on("click", function() {
					var $btn 			= $(this),
						$popup 			= $(popup),
						current_status 	= ($popup.data('status')) ? $popup.data('status') : false;
					
					if (!current_status){
						self.popupShow($popup);
					} else {
						self.popupHide($popup);
					}
				});
			};
			_CSUWAC.popupShow = function($popup){
				var self 		= this,
					status 		= $popup.data('status'),
					$btn 		= $popup.children('.cs-uwac__popup-btn'),
					$chatbox 	= $popup.children('.cs-uwac__popup-chatbox'),
					$overlay 	= $popup.children('.cs-uwac__popup-overlay'),
					popupTimeout;
				
				if (!status){
					$overlay.on('click.uwacWatchOutToClose',function(e){
						self.popupHide($popup);
					});
					
					// Clear CTA Autoopen
					clearInterval(self.init.ctaAutoOpenTimeout);
					
					// Clear CTA Animation
					clearInterval(self.init.ctaAnimationTimeout);
					
					
					$btn.addClass("cs-uwac__active");
					$popup.addClass("cs-uwac__active").data('status','open');
					$chatbox.addClass("cs-uwac__active");
					clearTimeout(popupTimeout);
					
					if (!$chatbox.hasClass("cs-uwac__active-items")) {
						popupTimeout = setTimeout(function() {
							$chatbox.addClass("cs-uwac__active-items");
						}, 100);
					}
				}
			};
			_CSUWAC.popupHide = function($popup){
				var status 		= $popup.data('status'),
					$btn 		= $popup.children('.cs-uwac__popup-btn'),
					$chatbox 	= $popup.children('.cs-uwac__popup-chatbox'),
					$overlay 	= $popup.children('.cs-uwac__popup-overlay'),
					popupTimeout;
				
				if (status == 'open'){
					$overlay.off('click.uwacWatchOutToClose');
					
					$btn.removeClass("cs-uwac__active");
					$popup.removeClass("cs-uwac__active").data('status',false);
					$chatbox.removeClass("cs-uwac__active");
					clearTimeout(popupTimeout);
					
					if ($chatbox.hasClass("cs-uwac__active-items")) {
						popupTimeout = setTimeout(function() {
							$popup.data('status',false);
							$chatbox.removeClass("cs-uwac__active-items cs-uwac__pending");
						}, 250);
					}
				}
			};
			_CSUWAC.GDPRInit = function(popup){
				var self 		= this;
				var settings 	= $(popup).data('widgetSettings');
				
				if (settings.gdpr === true){
					// Initial GDPR Cookie Check
					if (self.getGDPRCookie("uwac-gdpr-agreement") == 'agree') {
						$(popup).addClass('cs-uwac__popup--gdpr-ready');
					} else{
						$('.cs-uwac__popup-chatbox_content-item',popup).on('click.uwacGDPR','a.cs-uwac__popup-account--online',function(e){
							e.preventDefault();
							e.stopPropagation();
							
							var $parent = $(this).parents('.cs-uwac__popup-chatbox_content-list').siblings('.cs-uwac__popup-chatbox_notice-gdpr');
							$parent.addClass('cs-uwac__popup-chatbox_notice-gdpr--error');
							var gdprTimeout = setTimeout(function(){
								$parent.removeClass('cs-uwac__popup-chatbox_notice-gdpr--error');
							},550);
						});
					}

					// Click on GDPR checkbox
					$(".cs-uwac__popup-chatbox_notice-gdpr input",popup).on('change',function(){
						if (this.checked){
							if (self.getGDPRCookie("uwac-gdpr-agreement") == false){
								var $parent = $(this).parents('.cs-uwac__popup-chatbox_notice-gdpr');
								
								self.setGDPRCookie("uwac-gdpr-agreement", "agree", 30);
								
								if (self.getGDPRCookie("uwac-gdpr-agreement") == 'agree'){
									$('.cs-uwac__popup-chatbox_content-item',popup).off('click.uwacGDPR');
									
									$parent.addClass('cs-uwac__popup-chatbox_notice-gdpr--accepted');
									setTimeout(function(){
										$parent.slideUp();
									},300);
								} 
							}
						}
					});
				}
			};
			_CSUWAC.setGDPRCookie = function(cname,cvalue,exdays){
				var d = new Date();
				d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000);
				var expires = "expires=" + d.toUTCString();
				document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
			};
			_CSUWAC.getGDPRCookie = function(cname){
				var name = cname + "=";
				var ca = document.cookie.split(";");

				for (var i = 0; i < ca.length; i++) {
					var c = ca[i];
					while (c.charAt(0) == " ") {
						c = c.substring(1);
					}
					if (c.indexOf(name) == 0) {
						return c.substring(name.length, c.length);
					}
				}
				return false;
			};
			_CSUWAC.autoOpen = function(popup){
				var self = this;
				var settings 		= $(popup).data('widgetSettings'),
					auto_scrolled 	= false;
				
				var parseInteger = function(value){
					return parseFloat(parseFloat(value).toFixed(2));
				}
				
				if (settings.cta.autoopen){
					
					var autoopen_type = settings.cta.autoopen_type;
					if (autoopen_type == 'delay'){
						var delay = (settings.cta.autoopen_delay) ? parseInteger(settings.cta.autoopen_delay) * 1000 : 6 * 1000;
						
						self.init.ctaAutoOpenTimeout = setTimeout(function(){
							self.popupShow($(popup));
						},delay);
					} else if (autoopen_type == 'scroll'){
						$(window).on('scroll.uwac',function(){
							var wintop 		= $(window).scrollTop(),
								docheight 	= $(document).height(),
								winheight 	= $(window).height();
							
							var scrolltrigger = settings.cta.autoopen_scroll / 100;
							
							if ((wintop/(docheight-winheight)) >= scrolltrigger && auto_scrolled == false){
								auto_scrolled = true;
								self.popupShow($(popup));
							}
						});
					}
				}
			};
			_CSUWAC.ctaAnimation = function(popup){
				var self = this;
				var settings = $(popup).data('widgetSettings');
				
				if (settings.cta.effect){
					var $popup 		= $(popup);
					var fx_style 	= settings.cta.effect_style,
						fx 			= fx_style.effect,
						iteration 	= fx_style.iteration,
						delay 		= (fx_style.iteration_delay.slider1) ? fx_style.iteration_delay.slider1 : fx_style.iteration_delay,
						fx_class 	= fx + " animated ";
					
					
					var update_cta_animation = function(){
						var $popup = $(popup);
						
						$popup.removeClass(fx_class);
						$popup.addClass(fx_class).one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
							$(this).removeClass(fx_class);
						});
					};
					
					
					if (iteration == 'infinite'){
						self.init.ctaAnimationTimeout = setInterval(function(){
							update_cta_animation();
						},delay);
					} else {
						self.init.ctaAnimationTimeout = setTimeout(function(){
							update_cta_animation();
						},delay);
					}
					
				}
			};

			_CSUWAC.init($popup);
		});
	};
	
	$(document).ready(function() {
		$('.cs-uwac__popup-wrapper').CSUWAC();
	});
	
})( jQuery );
