<?php
class Uwac_Public {
	
	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;
	
	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
	
	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}
	
	/**
 	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/uwac-public.css', array(), $this->version, 'all' );

		// AJAX CALL: All Available Themes (for all customizable sections)
		wp_enqueue_style( $this->plugin_name . '_dynamic-themes',admin_url('admin-ajax.php').'?action=uwac_dynamic_themes', array($this->plugin_name), $this->version, 'all');
	}
	
	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {		
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/uwac-public.js', array( 'jquery' ), $this->version, false );
	}


	/**
	 * Generate dynamic css stylesheet
	 *
	 * @since    	1.0.0
	 * @param 		string 		String of css vars to apply to the parsed theme stylesheet
	 */
	public function dynamic_themes_callback() {
		$themes_obj = Uwac::get_themes();
		$themes 	= $themes_obj->get_themes();

		$themes_to_parse = array();

		// Parse Widget Themes
		foreach ($themes['widget'] as $theme){
			$themes_to_parse[] = (object) array(
				'type'	=> 'widget',
				'name'	=> $theme->raw_name,
			);
		}
		// Parse Button Themes
		foreach ($themes['button'] as $theme){
			$themes_to_parse[] = (object) array(
				'type'	=> 'button',
				'name'	=> $theme->raw_name,
			);
		}

		// Custom CSS Code
		$maybe_additional_css = cs_uwac_get_settings('customcss_status');
		$additional_css = false;
		if ($maybe_additional_css){
			$additional_css = cs_uwac_get_settings('customcss');
		}

		$themes_obj->parse_theme_stylesheet($themes_to_parse,$additional_css);

		die();
	}


	/**
	 * Floating Widget View
	 * 
	 * @since 1.0.0
	 */
	function floating_widget_view(){
		Uwac_Common::floating_widget_view();
	}


	/**
	 * Shortcode: Show Agents
	 *
	 * @return void
	 */
	function shortcode_agent($atts){
		$atts = shortcode_atts(
			array(
				'id' 		=> '',
			), 
			$atts 
		);

		$account_output = $this->account_button_view($atts['id'],'shortcode');

		return $account_output;
	}


	/**
	 * 
	 * WooCommerce Hooks
	 * 
	 */
	
	// Short Description
	function before_single_product_summary(){
		$accounts = $this->search_accounts('before_psd');
		echo $accounts;
	}
	function after_single_product_summary(){
		$accounts = $this->search_accounts('after_psd');
		echo $accounts;
	}

	// Add To Cart Form & Button
	function before_atc_form(){
		$accounts = $this->search_accounts('before_atcf');
		echo $accounts;
	}
	function before_atc_button(){
		$accounts = $this->search_accounts('before_atcb');
		echo $accounts;
	}
	function after_atc_form(){
		$accounts = $this->search_accounts('after_atcf');
		echo $accounts;
	}
	function after_atc_button(){
		$accounts = $this->search_accounts('after_atcb');
		echo $accounts;
	}

	// Product Meta
	function product_meta_start(){
		$accounts = $this->search_accounts('before_pm');
		echo $accounts;
	}
	function product_meta_end(){
		$accounts = $this->search_accounts('after_pm');
		echo $accounts;
	}

	// Product Tabs: Description & Reviews
	function woocommerce_before_tabs(){
		$accounts = $this->search_accounts('before_tabs');
		echo $accounts;
	}
	function woocommerce_after_tabs(){
		$accounts = $this->search_accounts('after_tabs');
		echo $accounts;
	}

	// Related Products
	function woocommerce_before_related_products(){
		$accounts = $this->search_accounts('before_related');
		echo $accounts;
	}
	function woocommerce_after_related_products(){
		$accounts = $this->search_accounts('after_related');
		echo $accounts;
	}



	/**
	 * Search User Account
	 *
	 * @param [type] $position
	 * @return void
	 */
	private function search_accounts($position){
		$accounts 			= cs_uwac_get_settings('user_accounts');
		$output_accounts 	= false;

		if (!empty($accounts)){
			foreach ($accounts as $account){
				$is_visible = (isset($account['useraccount_sections']['ua_visibility']['user_account_woocommerce_visibility'])) ? true : false;
				$has_hook 	= (isset($account['useraccount_sections']['ua_visibility']['user_account_woocommerce_position'])) ? $account['useraccount_sections']['ua_visibility']['user_account_woocommerce_position'] : false;
	
				if ($is_visible && $has_hook == $position){
					$account_id = $account['user_account_id'];
					$_account = $this->account_button_view($account_id);
					$output_accounts .= $_account;
				}
			}
		}

		return $output_accounts;
	}


	/**
	 * Show Account View by the required ID
	 *
	 * @param string $requested_id
	 * @return void
	 */
	private function account_button_view($requested_id = false,$is_shortcode = false){
		if (!$requested_id) { return false; }
		$themes_obj 	= Uwac::get_themes();
		$active_themes 	= Uwac::get_themes()->get_themes();

		$accounts 			= cs_uwac_get_settings('user_accounts');
		$account_index 		= cs_search_array_for_id($accounts,'user_account_id',$requested_id);
		
		if ($account_index === false || is_null($account_index)){ return false; }
		$account 			= $accounts[$account_index];
		$_account 			= new uwac_useraccount($account);
		$settings 			= $_account->get_settings();

		$is_visible = $_account->is_visible();
		if (!$is_shortcode && !$is_visible){ return false; }

		// Active Theme
		$theme_name 		= (isset($settings['theme']['theme'])) ? $settings['theme']['theme'] : false;
		$theme_settings 	= (isset($settings['theme']['settings'])) ? $settings['theme']['settings'] : false;
		if ($theme_name && $theme_settings){
			$active_theme = $active_themes['button'][$theme_name];
			$theme_settings = $active_theme->instance->parse_settings($theme_settings);
		}



		// Account Classes
		// ----------------------------------------------------------
		$account_classes = array();
		$account_classes[] = "cs-uwac__button-account--user_{account_id}";
		$account_classes[] = "cs-uwac__button-account--{account_status}";
		$account_classes[] = "cs-uwac__button-account_avatar--{account_avatar_type}";
		$account_classes[] = "cs-uwac__button-account_theme--{$theme_name}";


		// Account Inline Styles
		// ----------------------------------------------------------
		$account_inline_style = '';
		if ($theme_settings){
			$account_inline_style .= $theme_settings;
		}
		$account_inline_style = $themes_obj->clean_css_code($account_inline_style);


		// Render Account Template
		// ----------------------------------------------------------
		$tpl = new uwac_template(CS_UWAC_PLUGIN_PATH . '/common/views/account-single-view.tpl');
		$tpl->set('account_classes',implode(" ",$account_classes));
		$tpl->set('account_inline_style',$account_inline_style);
		$tpl->set('account_avatar',$settings['avatar']);
		$tpl->set('account_avatar_type',$settings['avatar_type']);
		$tpl->set('account_id',$settings['id']);
		$tpl->set('account_name',$settings['name']);
		$tpl->set('account_label',$settings['label']);
		$tpl->set('account_placeholder',$settings['placeholder']);
		$tpl->set('account_button_text',$settings['button_text']);
		$tpl->set('account_status',$settings['status']);
		$tpl->set('account_status_text',$settings['status_text']);
		$tpl->set('account_status_display',$settings['status_display']);
		$tpl->set('url',$settings['url']);
		$tpl->set('wazap_icon',$settings['wazap_icon']);
		$account_output = $tpl->render(false);

		return $account_output;
	}



	/**
	 * Helper Functions
	 */
	private function sanitize($string){
		return filter_var($string, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
	}
	private function clean($string){
		return preg_replace("/[^a-zA-Z0-9]+/", "", $string);
	}
}