<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.

class Uwac_Themes{
    protected $themes;
    protected $themes_path;
    protected $themes_uri;

    /**
	 * Initialize the collections used to maintain the themes
	 *
	 * @since    1.0.0
	 */
    public function __construct() {
		$this->themes 			= array();
        $this->themes_to_load   = array(
            'widget'    => (object) array(
                'base'  => 'Uwac_widget_theme',
                'path'  => CS_UWAC_PLUGIN_PATH . '/themes/widget/',
                'uri'   => CS_UWAC_PLUGIN_URI . '/themes/widget/',
			),
			'button'    => (object) array(
                'base'  => 'Uwac_button_theme',
                'path'  => CS_UWAC_PLUGIN_PATH . '/themes/button/',
                'uri'   => CS_UWAC_PLUGIN_URI . '/themes/button/',
            ),
        );
        $this->load_themes();
    }


	/**
	 * Load all available themes list
	 * If theme is activated/enabled, then run it
	 *
	 * @return void
	 */
    public function load_themes(){
        $themes_to_load = apply_filters('cs_uwac_load_themes',$this->themes_to_load);

        foreach ($themes_to_load as $_theme_key => $_theme_to_load){
			if (is_dir($_theme_to_load->path)){
                
                $themes_dir = new DirectoryIterator($_theme_to_load->path);

                foreach ($themes_dir as $theme){
                    if ($theme->isDir() && !$theme->isDot()) {
                        $_theme; $_theme_dir;
                        $theme_path 	= $theme->getRealPath();
                        $theme_name 	= $theme->getFilename();
                        $theme_uri 	    = $_theme_to_load->uri .'/'. $theme_name;
                        
                        $_theme_file    = $theme_path .'/'. $theme_name.'.php';
         
                        $include = $this->_get_include_object( $_theme_file, $_theme_to_load );
        
                        if (file_exists($_theme_file)){
                            
                            if ( !class_exists( $include->class ) ) {
                                @require_once $include->file;
                            }
                            if ( !class_exists( $include->class ) ) {
                                trigger_error( "{$this->name} -- Unable to load class {$include->class}. see the readme for class and file naming conventions" );
                                continue;
                            }
        
                            $theme_instance = new $include->class( $this );
                            $include->instance = $theme_instance;
                            $this->{$include->object_name} = $theme_instance;
                            $this->themes[$_theme_key][ $include->object_name ] = $include;
                        }
                    }
                }
            }
        }

        do_action('cs_uwac_load_themes_after',$this->themes);
	}
	

	/**
	 * Get themes
	 */
	public function get_themes(){
		return $this->themes;
	}


    /**
	 * Returns an object with all information about a file to include
	 *
	 * Fields:
	 * file - path to file
	 * name - Title case name of class
	 * object_name - lowercase name that will become $this->{object_name}
	 * native - whether this is a native boilerplate class
	 *  base - the base of the class name (either Plugin_Boilerplate or the parent class name)
	 *  class - The name of the class
	 *
	 * @param string $file the file to include
	 * @return object the file object
	 */
	private function _get_include_object( $file , $theme_data ) {
		$class = new stdClass();
		$class->file = $file;
		$name = basename( $file, '.php' );
		$raw_name = $name;
		$name = str_replace( '-', '_', $name );
		$name = str_replace( '_', ' ', $name );
		$class->raw_name 	= $raw_name;
		$class->name 		= str_replace( ' ', '_', ucwords( $name ) );
		$class->object_name = str_replace( ' ', '_', $name );
		$class->human_name 	= ucwords( $name );
        $class->path        = $theme_data->path . $class->raw_name;
        $class->uri         = $theme_data->uri . $class->raw_name;
        $class->base        = $theme_data->base;
        $class->type        = 'dynamic';
		$class->class 	    = $class->base . '_' . $class->name;
		
		return $class;
    }


    public function parse_theme_settings($theme,$settings){
		if ($theme && $settings){
            $theme_instance = $this->$theme;

            if ($theme_instance){
                $parsed_settings = $theme_instance->parse_settings($settings);
                return $parsed_settings;
            }
		}
	}


	public function parse_theme_stylesheet($themes_to_parse,$additional_css_code = false){
        $themes = $this->themes;
        $buffer = "";
        
		// Add Theme Vars
		if (isset($additional_css_code)){
			$buffer .= $additional_css_code;
		}

		// Parse Theme Stylesheet
		foreach ($themes_to_parse as $theme){
			$theme_type = $theme->type;
			$theme_name = $theme->name;
            $_theme     = $themes[$theme_type][$theme_name];
			$stylesheet = $_theme->path . '/' . $_theme->raw_name .'.css';
			
			if (file_exists($stylesheet)){
                $buffer .= file_get_contents($stylesheet);
			}
		}		
	

		// CSS MINIFY & COMPRESS
		// --------------------------------------------------------------------------
        $buffer = $this->clean_css_code($buffer);

		// Enable GZip encoding.
		ob_start("ob_gzhandler");

		// Enable caching
		header('Cache-Control: public');

		// Expire in one day
		// header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 86400) . ' GMT');

		// Set the correct MIME type, because Apache won't set it for us
		header("Content-type: text/css");
		
		// Write everything out
		echo "/* Created by Castorstudio.com */";
		echo($buffer);

		exit;
	}


	/**
	 * Clean CSS Code
	 *
	 * @param [type] $code
	 * @return void
	 */
	public function clean_css_code($code){
		// Remove comments
		$code = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $code);
		// Remove space after colons
		$code = str_replace(': ', ':', $code);
		// Remove whitespace
		$code = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $code);
		// Remove space near commas
		$code = str_replace(', ', ',', $code);
		$code = str_replace(' ,', ',', $code);
		// Remove space before brackets
		$code = str_replace('{ ', '{', $code);
		$code = str_replace('} ', '}', $code);
		$code = str_replace(' {', '{', $code);
		$code = str_replace(' }', '}', $code);
		// Remove last dot with comma
		$code = str_replace(';}', '}', $code);
		// Remove space before and after >
		$code = str_replace('> ','>', $code);
		$code = str_replace(' >','>', $code);

		return $code;
	}

}