<?php
if (!class_exists('uwac_floatingwidget')){
	class uwac_floatingwidget{
		private $widget_data;
		private $settings;
		
		public function __construct($widget_data){
			$this->widget_data 	= $widget_data;
			$this->settings 	= $this->set_settings();
		}
		
		public function is_visible(){
			$settings 	= $this->settings;
			
			/**
			 * Temporarily Disabled Status
			 */
			if ($settings['status']){
				return false;
			}
			

			/**
			 * Visibility on Devices
			 */
			if (wp_is_mobile()){
				if (!$settings['visibility']['mobile']){
					return false;
				}
			} else if (!wp_is_mobile()){
				if (!$settings['visibility']['desktop']){
					return false;
				}
			}
			
			
			/**
			* Visibility based on specific criteria
			*/
			$visibility_criteria 	= $settings['visibility']['criteria'];
			$visibility_type 		= $settings['visibility']['type'];
			$visibility_content 	= $settings['visibility']['content'];
			$is_on_criteria			= false;
			
			global $hook_suffix;
			
			if (!$hook_suffix){
				if ($visibility_type == 'home'){
					if ($visibility_criteria == 'include'){
						$is_on_criteria = (is_home() || is_front_page()) ? true : false;
					} else {
						$is_on_criteria = (!is_home() || !is_front_page()) ? true : false;
					}
				} else if ($visibility_type == 'all'){
					if ($visibility_criteria == 'include'){
						$is_on_criteria = true;
					} else {
						$is_on_criteria = false;
					}
				} else if ($visibility_type == 'pages'){
					if (is_page()){
						global $post;
						$page_id = $post->ID;
						
						if ($visibility_criteria == 'include'){
							$is_on_criteria = (in_array($page_id,$visibility_content)) ? true : false;
						} else {
							$is_on_criteria = (!in_array($page_id,$visibility_content)) ? true : false;
						}
					} else {
						$is_on_criteria = false;
					}
				} else if ($visibility_type == 'posttypes'){
					if ($visibility_criteria == 'include'){
						$is_on_criteria = (is_singular($visibility_content)) ? true : false;
					} else {
						$is_on_criteria = (!is_singular($visibility_content)) ? true : false;
					}
				} else if ($visibility_type == 'posts'){
					global $post;
					$post_id = $post->ID;
					
					if ($visibility_criteria == 'include'){
						$is_on_criteria = (is_singular('post') && in_array($post_id,$visibility_content)) ? true : false;
					} else {
						$is_on_criteria = (is_singular('post') && !in_array($post_id,$visibility_content)) ? true : false;
					}
				} else if ($visibility_type == 'post_cat'){
					global $post;
					
					if ($visibility_criteria == 'include'){
						$is_on_criteria = (is_singular('post') && Uwac_Common::in_post_category($visibility_content,$post)) ? true : false;
					} else {
						$is_on_criteria = (is_singular('post') && !Uwac_Common::in_post_category($visibility_content,$post)) ? true : false;
					}
				} else if ($visibility_type == 'products'){
					global $post;
					$product_id = $post->ID;
					
					if ($visibility_criteria == 'include'){
						$is_on_criteria = (is_singular('product') && in_array($product_id,$visibility_content)) ? true : false;
					} else {
						$is_on_criteria = (is_singular('product') && !in_array($product_id,$visibility_content)) ? true : false;
					}
				} else if ($visibility_type == 'product_cat'){
					global $post;
	
					if ($visibility_criteria == 'include'){
						$is_on_criteria = (is_singular('product') && Uwac_Common::in_product_category($visibility_content,$post)) ? true : false;
					} else {
						$is_on_criteria = (is_singular('product') && !Uwac_Common::in_product_category($visibility_content,$post)) ? true : false;
					}
				}
			} else {
				if ($visibility_type == 'admin_all'){
					$is_on_criteria = true;
				} else if ($visibility_type == 'admin_pages'){
					$current_screen_id 		= $this->get_current_admin_page();

					if ($visibility_criteria == 'include'){
						$is_on_criteria = (in_array($current_screen_id,$visibility_content)) ? true : false;
					} else {
						$is_on_criteria = (!in_array($current_screen_id,$visibility_content)) ? true : false;
					}
				}
			}
			
			return $is_on_criteria;
		}
		
		public function get_settings(){
			return $this->settings;
		}
		
		private function set_settings(){
			$widget = $this->widget_data;
			$sections = $widget['floatingwidget_sections'];
			
			// Visibility
			$visibility_content_type = (isset($sections['fw_visibility']['floating_widget_visibility_content_type'])) ? $sections['fw_visibility']['floating_widget_visibility_content_type'] : 'all';
			$visibility_content = false;
			if ($visibility_content_type == 'pages'){
				$visibility_content = (isset($sections['fw_visibility']['floating_widget_pages'])) ? $sections['fw_visibility']['floating_widget_pages'] : false;
			} else if ($visibility_content_type == 'posttypes'){
				$visibility_content = (isset($sections['fw_visibility']['floating_widget_posttypes'])) ? $sections['fw_visibility']['floating_widget_posttypes'] : false;
			} else if ($visibility_content_type == 'posts'){
				$visibility_content = (isset($sections['fw_visibility']['floating_widget_posts'])) ? $sections['fw_visibility']['floating_widget_posts'] : false;
			} else if ($visibility_content_type == 'post_cat'){
				$visibility_content = (isset($sections['fw_visibility']['floating_widget_post_cat'])) ? $sections['fw_visibility']['floating_widget_post_cat'] : false;
			} else if ($visibility_content_type == 'products'){
				$visibility_content = (isset($sections['fw_visibility']['floating_widget_products'])) ? $sections['fw_visibility']['floating_widget_products'] : false;
			} else if ($visibility_content_type == 'product_cat'){
				$visibility_content = (isset($sections['fw_visibility']['floating_widget_product_cat'])) ? $sections['fw_visibility']['floating_widget_product_cat'] : false;
			} else if ($visibility_content_type == 'admin_pages'){
				$visibility_content = (isset($sections['fw_visibility']['floating_widget_admin_pages'])) ? $sections['fw_visibility']['floating_widget_admin_pages'] : false;
			}
			
			
			// User Accounts
			$enabled_accounts = (isset($sections['fw_accounts']['floatingwidget_accounts_selected']['enabled'])) ? $sections['fw_accounts']['floatingwidget_accounts_selected']['enabled'] : false;
			$_enabled_accounts = array();
			if ($enabled_accounts){
				foreach($enabled_accounts as $account_id => $account_name){
					$_enabled_accounts[] = $account_id;
				}
			}


			// Theme
			$theme_name 	= (isset($sections['fw_theme']['floatingwidget_theme'])) ? $sections['fw_theme']['floatingwidget_theme'] : false;
			$theme_settings = (isset($sections['fw_theme']['floatingwidget_theme_settings']["uwac_theme-{$theme_name}"])) ? $sections['fw_theme']['floatingwidget_theme_settings']["uwac_theme-{$theme_name}"] : false;
			
			$settings = array(
				'name' 			=> (isset($widget['floatingwidget_name'])) ? $widget['floatingwidget_name'] : 'nonamed',
				'id'			=> (isset($widget['floatingwidget_id'])) ? $widget['floatingwidget_id'] : 'no_id',
				'status'		=> (isset($widget['floatingwidget_status'])) ? $widget['floatingwidget_status'] : false,
				'visibility'	=> array(
					'desktop'	=> (isset($sections['fw_visibility']['floating_widget_show_on_desktop'])) ? true : false,
					'mobile'	=> (isset($sections['fw_visibility']['floating_widget_show_on_mobile'])) ? true : false,
					'criteria'	=> (isset($sections['fw_visibility']['floating_widget_visibility_criteria'])) ? $sections['fw_visibility']['floating_widget_visibility_criteria'] : 'include',
					'type'		=> $visibility_content_type,
					'content'	=> $visibility_content,
				),
				'calltoaction'	=> array(
					'autoopen'			=> (isset($sections['fw_cta']['floating_widget_autoopen_status'])) ? true : false,
					'autoopen_type'		=> (isset($sections['fw_cta']['floating_widget_autoopen_type'])) ? $sections['fw_cta']['floating_widget_autoopen_type'] : 'delay',
					'autoopen_delay'	=> (isset($sections['fw_cta']['floating_widget_autoopen_delay'])) ? ((is_array($sections['fw_cta']['floating_widget_autoopen_delay'])) ? $sections['fw_cta']['floating_widget_autoopen_delay']['slider1'] : $sections['fw_cta']['floating_widget_autoopen_delay']) : false,
					'autoopen_scroll'	=> (isset($sections['fw_cta']['floating_widget_autoopen_scroll'])) ? ((is_array($sections['fw_cta']['floating_widget_autoopen_scroll'])) ? $sections['fw_cta']['floating_widget_autoopen_scroll']['slider1'] : $sections['fw_cta']['floating_widget_autoopen_scroll']) : false,
					'effect'			=> (isset($sections['fw_cta']['floating_widget_ctaeffect_status'])) ? $sections['fw_cta']['floating_widget_ctaeffect_status'] : false,
					'effect_style'		=> array(
						'effect'	=> (isset($sections['fw_cta']['floating_widget_ctaeffect']['effect'])) ? $sections['fw_cta']['floating_widget_ctaeffect']['effect'] : false,
						'iteration'	=> (isset($sections['fw_cta']['floating_widget_ctaeffect']['iteration'])) ? $sections['fw_cta']['floating_widget_ctaeffect']['iteration'] : false,
						'iteration_delay'	=> (isset($sections['fw_cta']['floating_widget_ctaeffect']['iteration_delay']['slider1'])) ? $sections['fw_cta']['floating_widget_ctaeffect']['iteration_delay']['slider1'] : $sections['fw_cta']['floating_widget_ctaeffect']['iteration_delay'],
					),
				),
				'button'		=> array(
					'label_visibility'	=> (isset($sections['fw_button']['floatingwidget_button_label_status'])) ? $sections['fw_button']['floatingwidget_button_label_status'] : false,
					'label'				=> (isset($sections['fw_button']['floatingwidget_button_label'])) ? $sections['fw_button']['floatingwidget_button_label'] : __('Need Help? <strong>Chat with us!</strong>','uwac'),
					'icon'				=> (isset($sections['fw_button']['floatingwidget_button_icon'])) ? $sections['fw_button']['floatingwidget_button_icon'] : false,
					// 'icon_status'		=> --uwac-btn-icon-display
				),
				'popup'			=> array(
					'title'			=> (isset($sections['fw_popup']['floatingwidget_text_title'])) ? $sections['fw_popup']['floatingwidget_text_title'] : __('Start a Conversation','uwac'),
					'description'	=> (isset($sections['fw_popup']['floatingwidget_text_description'])) ? $sections['fw_popup']['floatingwidget_text_description'] : __('Hi! Click one of our members below to chat on <strong>WhatsApp</strong>','uwac'),
					'response_time'	=> (isset($sections['fw_popup']['floatingwidget_text_response_time'])) ? $sections['fw_popup']['floatingwidget_text_response_time'] : __('We usually reply in a <strong>few minutes</strong>','uwac'),
				),
				'gdpr'			=> array(
					'status'	=> (isset($sections['fw_gdpr']['floatingwidget_gdpr_status'])) ? $sections['fw_gdpr']['floatingwidget_gdpr_status'] : false,
					'text'		=> (isset($sections['fw_gdpr']['floatingwidget_gdpr_text'])) ? $sections['fw_gdpr']['floatingwidget_gdpr_text'] : false,
				),
				'accounts'		=> array(
					'type'		=> (isset($sections['fw_accounts']['floatingwidget_accounts_type'])) ? $sections['fw_accounts']['floatingwidget_accounts_type'] : false,
					'enabled'	=> $_enabled_accounts,
				),
				'theme'			=> array(
					'theme'		=> $theme_name,
					'settings'	=> $theme_settings,
				),
			);
			
			return $settings;
		}

		private function get_current_admin_page(){
			global $hook_suffix;
			global $pagenow;
			$hook = get_current_screen();

			$args = array();

			if ($hook->taxonomy){
				$args['taxonomy'] = $hook->taxonomy;
			}

			$pt = $hook->post_type;
			if ($pt){
				$core_pt = array('post');
				if (!in_array($pt,$core_pt)){
					$args['post_type'] = $hook->post_type;
				}
			}

			preg_match('/^(.*?)_page_/',$hook->base,$is_custom_page);
			if ($is_custom_page){
				$current_screen_id = preg_replace('/^(.*?)_page_/','', $hook->base);
				$pagenow = 'admin.php';
				$args = array();
				$args['page'] = $current_screen_id;
			}

			$output = add_query_arg( $args, $pagenow);
			return $output;
		}
		
	}
}



