(function( $ ) {
	'use strict';
	
	var $document 	= $(document),
		$window 	= $(window),
		$body 		= $(document.body);
	
	window._UWAC = {};
	var _UWAC = window._UWAC;
	
	_UWAC.settings = {};
	var settings = _UWAC.settings;
	
	
	/**
	* DEBUG Log
	* 
	* @since 1.2.0
	*/
	settings.debug = true;
	var CS_DEBUG = function(msg,obj = false){
		if (settings.debug){
			var version = settings.general.plugin_version;
			console.log('[>] Ultimate WhatsApp Chat '+version+': '+msg);
			if (obj){
				console.log(obj);
			}
		}
	};


	_UWAC.general = {
		init: function(){
			this.settingsFramework();
		},
		settingsFramework: function(){
			var $cssf = $('.cssf-framework.cssf-framework--cs-uwac');
			if ($cssf.length){
				var $tab_accounts 		= $('#cssf-tab-accounts',$cssf),
					$tab_widgets		= $('#cssf-tab-floating_widget',$cssf),
					global_account_id 	= 0;
				

				/**
				 * TAB: User Accounts
				 */
				// Pre-fill User Account ID Data
				$('input[name*="[user_account_id]"]',$tab_accounts).each(function(){
					var $this 				= $(this),
						$parent 			= $this.parents('.cssf-group'),
						value 				= $this.val(),
						id 					= value.split('_').pop(),
						name 				= value.split('_').slice(0, -1).join('_');

					$this.data('id',id).data('originalNameId',name);
				});

				// Increment Global User Account ID
				$('.cssf-field-id_user_accounts > .cssf-add-group',$tab_accounts).on('click',function(){
					var $id_counter = $('input[name*=user_account_idcounter]',$tab_accounts),
						new_val 	= parseInt($id_counter.val()) + 1;
					
					global_account_id = new_val;

					$id_counter.val(new_val);
				});

				// Edit User Account ID
				$tab_accounts.on('change','input[name*="[user_account_name]"]',function(){
					var $this 				= $(this),
						$parent 			= $this.parents('.cssf-group'),
						$account_id_field 	= $('input[name*=user_account_id]',$parent),
						value 				= $this.val(),
						new_value 			= value.replace(/\s+/g, '_').toLowerCase() + "_" + global_account_id;
					
					if (!$account_id_field.val().length){
						$account_id_field.val(new_value).data('id',global_account_id).data('originalNameId',value);
					}
				});
				$tab_accounts.on('change','input[name*="[user_account_id]"]',function(){
					var $this 				= $(this),
						$parent 			= $this.parents('.cssf-group'),
						$account_name_field = $('input[name*=user_account_name]',$parent),
						id 					= $this.data('id'),
						name_id 			= $this.data('originalNameId'),
						value 				= ($this.val()) ? $this.val() : name_id,
						new_value 			= value.replace(/\s+/g, '_').toLowerCase() + "_" + id;
					
					$this.val(new_value);
				});


				/**
				 * TAB: Floating Widgets
				 */
				// Pre-fill Widget ID Data
				$('input[name*="[floatingwidget_id]"]',$tab_widgets).each(function(){
					var $this 				= $(this),
						$parent 			= $this.parents('.cssf-group'),
						value 				= $this.val(),
						id 					= value.split('_').pop(),
						name 				= value.split('_').slice(0, -1).join('_');

					$this.data('id',id).data('originalNameId',name);
				});

				// Increment Global Widget ID
				$('.cssf-field-id_floating_widgets > .cssf-add-group',$tab_widgets).on('click',function(){
					var $id_counter = $('input[name*=floatingwidget_idcounter]',$tab_widgets),
						new_val 	= parseInt($id_counter.val()) + 1;
					
					global_account_id = new_val;

					$id_counter.val(new_val);
				});

				// Edit Widget ID
				$tab_widgets.on('change','input[name*="[floatingwidget_name]"]',function(){
					var $this 				= $(this),
						$parent 			= $this.parents('.cssf-group'),
						$account_id_field 	= $('input[name*=floatingwidget_id]',$parent),
						value 				= $this.val(),
						new_value 			= value.replace(/\s+/g, '_').toLowerCase() + "_" + global_account_id;
					
					if (!$account_id_field.val().length){
						$account_id_field.val(new_value).data('id',global_account_id).data('originalNameId',value);
					}
				});
				$tab_widgets.on('change','input[name*="[floatingwidget_id]"]',function(){
					var $this 				= $(this),
						$parent 			= $this.parents('.cssf-group'),
						$account_name_field = $('input[name*=floatingwidget_name]',$parent),
						id 					= $this.data('id'),
						name_id 			= $this.data('originalNameId'),
						value 				= ($this.val()) ? $this.val() : name_id,
						new_value 			= value.replace(/\s+/g, '_').toLowerCase() + "_" + id;
					
					$this.val(new_value);
				});


				// Reloading User Accounts
				$tab_widgets.on('click','a.button[name*="[floatingwidget_accounts_reload]"]',function(e){
					e.preventDefault();
					var $button 	= $(this),
						$user_list 	= $button.parent().siblings('.cssf-element-sorter').find('.cssf-sorter-wrapper'),
						$enabled 	= $user_list.find('.cssf-enabled'),
						$disabled 	= $user_list.find('.cssf-disabled'),
						path_field	= $button.parent().siblings('.cssf-element-active-user-accounts').find('input').attr('name'),
						current_name_path = path_field.substring(0, path_field.indexOf('[floatingwidget_sections]'));

					// Check Previous State
					var $_enabled = [];
					$enabled.find('input').each(function(index,target){
						var $input 	= $(target),
							id 		= $input.data('elementId'),
							name 	= $input.val();
						
						$_enabled.push(id);
					});

					var $_disabled = [];
					$disabled.find('input').each(function(index,target){
						var $input 	= $(target),
							id 		= $input.data('elementId'),
							name 	= $input.val();
						
						$_disabled.push(id);
					});

					// Remove Current Accounts
					$enabled.html('');
					$disabled.html('');

					var $current_user_accounts = $('.cssf-field-id_user_accounts',$tab_accounts).children('.cssf-groups');
					var $output_enabled = [];
					var $output_disabled = [];
					$.each($current_user_accounts.children('.cssf-group'),function(index,target){
						var item_index 			= $(target).data('itemIndex'),
							user_name 			= $('.cssf-field-id_user_account_name input',target).val(),
							user_id 			= $('.cssf-field-id_user_account_id input',target).val(),
							$hidden_on_widgets 	= $('.cssf-field-id_user_account_visibility input',$(target)),
							is_hidden 			= $hidden_on_widgets.is(':checked');

						if (!is_hidden){
							var new_field_name_enabled 	= current_name_path + "[floatingwidget_sections][fw_accounts][floatingwidget_accounts_selected][enabled]["+user_id+"]",
								new_field_name_disabled = current_name_path + "[floatingwidget_sections][fw_accounts][floatingwidget_accounts_selected][disabled]["+user_id+"]",
								$new_field_enabled 		= "<li class='ui-sortable-handle'><input type='hidden' name='"+new_field_name_enabled+"' value='"+user_name+"' data-element-id='"+user_id+"'><label>"+user_name+"</label></li>",
								$new_field_disabled 	= "<li class='ui-sortable-handle'><input type='hidden' name='"+new_field_name_disabled+"' value='"+user_name+"' data-element-id='"+user_id+"'><label>"+user_name+"</label></li>";
	
							if ($_enabled.includes(user_id)){
								$output_enabled += $new_field_enabled;
							} else {
								$output_disabled += $new_field_disabled;
							}
						}
					});

					$enabled.append($output_enabled);
					$disabled.append($output_disabled);
				});
			}
		},
	};

	$(document).ready(function() {
		_UWAC.general.init();
	});
	
	
})( jQuery, window);
